--[[
	CustomFertilizersPF.lua
	
	Autor: 		Edomod - Sbaffo Farming
	Version: 	1.0 
	
]]

CustomFertilizersPF = {};

CustomFertilizersPF.BASE_DIRECTORY = g_currentModDirectory;
CustomFertilizersPF.modTablePF = "";

-- RIMOSSA linea che causava errore GUI (non necessaria per il funzionamento)
-- FS25_precisionFarming.FarmlandStatsDialog.MOD_DIR = CustomFertilizersPF.BASE_DIRECTORY;

function CustomFertilizersPF:finalizeTypes()
	for _, mod in pairs(g_modManager.mods) do
		if mod.title == "Precision Farming" and g_modIsLoaded[mod.modName] then	
			CustomFertilizersPF.modTablePF = _G[mod.modName];

			-- RIPRISTINATA sovrascrittura loadMap essenziale
			CustomFertilizersPF.modTablePF.PrecisionFarming.loadMap = Utils.overwrittenFunction(CustomFertilizersPF.modTablePF.PrecisionFarming.loadMap, CustomFertilizersPF.loadMapPF);

			CustomFertilizersPF.modTablePF.ExtendedSprayer.getCurrentSprayerMode = Utils.overwrittenFunction(CustomFertilizersPF.modTablePF.ExtendedSprayer.getCurrentSprayerMode, CustomFertilizersPF.getCurrentSprayerModePF);
			CustomFertilizersPF.modTablePF.ExtendedSprayer.onEndWorkAreaProcessing = Utils.appendedFunction(CustomFertilizersPF.modTablePF.ExtendedSprayer.onEndWorkAreaProcessing, CustomFertilizersPF.onEndWorkAreaProcessingPF);

			CustomFertilizersPF.modTablePF.FarmlandStatisticCounter.loadFromItemsXML = Utils.appendedFunction(CustomFertilizersPF.modTablePF.FarmlandStatisticCounter.loadFromItemsXML, CustomFertilizersPF.loadFromItemsXMLPF);
			CustomFertilizersPF.modTablePF.FarmlandStatisticCounter.saveToXMLFile = Utils.appendedFunction(CustomFertilizersPF.modTablePF.FarmlandStatisticCounter.saveToXMLFile, CustomFertilizersPF.saveToXMLFilePF);
			CustomFertilizersPF.modTablePF.FarmlandStatisticCounter.reset = Utils.appendedFunction(CustomFertilizersPF.modTablePF.FarmlandStatisticCounter.reset, CustomFertilizersPF.resetPF);
			CustomFertilizersPF.modTablePF.FarmlandStatisticCounter.onReadStream = Utils.appendedFunction(CustomFertilizersPF.modTablePF.FarmlandStatisticCounter.onReadStream, CustomFertilizersPF.onReadStreamPF);
			CustomFertilizersPF.modTablePF.FarmlandStatisticCounter.onWriteStream = Utils.appendedFunction(CustomFertilizersPF.modTablePF.FarmlandStatisticCounter.onWriteStream, CustomFertilizersPF.onWriteStreamPF);

			CustomFertilizersPF.modTablePF.FarmlandStatsDialog.setData = Utils.appendedFunction(CustomFertilizersPF.modTablePF.FarmlandStatsDialog.setData, CustomFertilizersPF.setDataPF);
			
			break;
		end;
	end;
end;

TypeManager.finalizeTypes = Utils.prependedFunction(TypeManager.finalizeTypes, CustomFertilizersPF.finalizeTypes);


function CustomFertilizersPF:loadMapPF(superFunc, mapFileName)
	if g_modIsLoaded[CustomFertilizersPF.modTablePF.PrecisionFarming.MOD_NAME] then
		if not Utils.getNoNil(getXMLBool(g_savegameXML, "gameSettings.precisionFarming#initialized"), false) then
			self.firstTimeRun = true;

			setXMLBool(g_savegameXML, "gameSettings.precisionFarming#initialized", true);

			g_gameSettings:save();
		end;

		self.mapFilename = mapFileName;
		self.configFileName = Utils.getFilename("maps/config/precisionFarming.xml", CustomFertilizersPF.BASE_DIRECTORY);

		local configXML = loadXMLFile("ConfigXML", self.configFileName);

		for valueMapIndex = 1, #self.valueMaps do
			self.valueMaps[valueMapIndex]:loadFromXML(configXML, "precisionFarming", CustomFertilizersPF.modTablePF.PrecisionFarming.BASE_DIRECTORY, self.configFileName, mapFileName);
		end;

		for valueMapIndex = 1, #self.valueMaps do
			self.valueMaps[valueMapIndex]:postLoad(configXML, "precisionFarming", CustomFertilizersPF.modTablePF.PrecisionFarming.BASE_DIRECTORY, self.configFileName, mapFileName);
		end;

		self.aiExtension:loadFromXML(configXML, "precisionFarming.aiExtension", CustomFertilizersPF.modTablePF.PrecisionFarming.BASE_DIRECTORY, self.configFileName, mapFileName);
		self.fieldInfoDisplayExtension:loadFromXML(configXML, "precisionFarming.fieldInfoDisplayExtension", CustomFertilizersPF.modTablePF.PrecisionFarming.BASE_DIRECTORY, self.configFileName, mapFileName);
		self.harvestExtension:loadFromXML(configXML, "precisionFarming.harvestExtension", CustomFertilizersPF.modTablePF.PrecisionFarming.BASE_DIRECTORY, self.configFileName, mapFileName);
		self.helplineExtension:loadFromXML(configXML, "precisionFarming.helplineExtension", CustomFertilizersPF.modTablePF.PrecisionFarming.BASE_DIRECTORY, self.configFileName, mapFileName);
		self.farmlandStatistics:loadFromXML(configXML, "precisionFarming.farmlandStatistics", CustomFertilizersPF.modTablePF.PrecisionFarming.BASE_DIRECTORY, self.configFileName, mapFileName);
		self.additionalFieldBuyInfo:loadFromXML(configXML, "precisionFarming.additionalFieldBuyInfo", CustomFertilizersPF.modTablePF.PrecisionFarming.BASE_DIRECTORY, self.configFileName, mapFileName);
		self.cropSensorLinkageData:loadFromXML(configXML, "precisionFarming.cropSensorLinkageData", CustomFertilizersPF.modTablePF.PrecisionFarming.BASE_DIRECTORY, self.configFileName, mapFileName);
		self.manureSensorLinkageData:loadFromXML(configXML, "precisionFarming.manureSensorLinkageData", CustomFertilizersPF.modTablePF.PrecisionFarming.BASE_DIRECTORY, self.configFileName, mapFileName);
		self.sprayerNodeData:loadFromXML(configXML, "precisionFarming.sprayerNodeData", CustomFertilizersPF.modTablePF.PrecisionFarming.BASE_DIRECTORY, self.configFileName, mapFileName);
		self.subsidies:loadFromXML(configXML, "precisionFarming.subsidies", CustomFertilizersPF.modTablePF.PrecisionFarming.BASE_DIRECTORY, self.configFileName, mapFileName);
		self.environmentalScore:loadFromXML(configXML, "precisionFarming.environmentalScore", CustomFertilizersPF.modTablePF.PrecisionFarming.BASE_DIRECTORY, self.configFileName, mapFileName);
		self.extendedWeedControl:loadFromXML(configXML, "precisionFarming.extendedWeedControl", CustomFertilizersPF.modTablePF.PrecisionFarming.BASE_DIRECTORY, self.configFileName, mapFileName);

		delete(configXML);
	end;
end;


function CustomFertilizersPF:getCurrentSprayerModePF(superFunc)
	local sourceVehicle, fillUnitIndex = CustomFertilizersPF.modTablePF.ExtendedSprayer.getFillTypeSourceVehicle(self);
	local lastValidFillType = sourceVehicle:getFillUnitLastValidFillType(fillUnitIndex);

	if lastValidFillType == FillType.LIME then
		return true, false;
	elseif  self:getIsAIActive() or lastValidFillType == FillType.FERTILIZER or (lastValidFillType == FillType.LIQUIDFERTILIZER or (lastValidFillType == FillType.MANURE or (lastValidFillType == FillType.LIQUIDMANURE or lastValidFillType == FillType.DIGESTATE))) or (FillType.COMPOST ~= nil and lastValidFillType == FillType.COMPOST) or (FillType.DIGESTATO_SOLIDO ~= nil and lastValidFillType == FillType.DIGESTATO_SOLIDO) then
		return false, true;
	else
		return false, false;
	end;
end;

function CustomFertilizersPF:onEndWorkAreaProcessingPF(dt, hasProcessed)
	local specSprayer = self.spec_sprayer;

	if self.isServer and specSprayer.workAreaParameters.isActive then
		local sprayerVehicle = specSprayer.workAreaParameters.sprayVehicle;
		local usageAmount = specSprayer.workAreaParameters.usage;
		local sprayFillType = specSprayer.workAreaParameters.sprayFillType;

		if (sprayerVehicle ~= nil or self:getIsAIActive()) and self:getIsTurnedOn() then
			local lastRegularUsage = self[CustomFertilizersPF.modTablePF.ExtendedSprayer.SPEC_TABLE_NAME].lastRegularUsage;
			local statistics, _, fieldId = self:getPFStatisticInfo();

			if statistics ~= nil and fieldId ~= nil then
				if FillType.COMPOST ~= nil and sprayFillType == FillType.COMPOST then
					statistics:updateStatistic(fieldId, "usedCompost", usageAmount);
					statistics:updateStatistic(fieldId, "usedCompostRegular", lastRegularUsage);
					return;
				end;
				
				-- AGGIUNTA per DIGESTATO_SOLIDO
				if FillType.DIGESTATO_SOLIDO ~= nil and sprayFillType == FillType.DIGESTATO_SOLIDO then
					statistics:updateStatistic(fieldId, "usedDigestatoSolido", usageAmount);
					statistics:updateStatistic(fieldId, "usedDigestatoSolidoRegular", lastRegularUsage);
					return;
				end;
			end;
		end;
	end;
end;

function CustomFertilizersPF:loadFromItemsXMLPF(xmlFile, key)
    if FillType.COMPOST ~= nil then
        self.usedCompost = xmlFile:getFloat(key .. "#usedCompost", self.usedCompost) or 0;
        self.usedCompostRegular = xmlFile:getFloat(key .. "#usedCompostRegular", self.usedCompostRegular) or 0;
    end;
    
    if FillType.DIGESTATO_SOLIDO ~= nil then
        self.usedDigestatoSolido = xmlFile:getFloat(key .. "#usedDigestatoSolido", self.usedDigestatoSolido) or 0;
        self.usedDigestatoSolidoRegular = xmlFile:getFloat(key .. "#usedDigestatoSolidoRegular", self.usedDigestatoSolidoRegular) or 0;
    end;
end;

function CustomFertilizersPF:saveToXMLFilePF(xmlFile, key, usedModNames)
    if FillType.COMPOST ~= nil then
        local usedCompost = self.usedCompost ~= nil and self.usedCompost or 0;
        local usedCompostRegular = self.usedCompostRegular ~= nil and self.usedCompostRegular or 0;

        xmlFile:setFloat(key .. "#usedCompost", usedCompost);
        xmlFile:setFloat(key .. "#usedCompostRegular", usedCompostRegular);
    end;
    
    if FillType.DIGESTATO_SOLIDO ~= nil then
        local usedDigestatoSolido = self.usedDigestatoSolido ~= nil and self.usedDigestatoSolido or 0;
        local usedDigestatoSolidoRegular = self.usedDigestatoSolidoRegular ~= nil and self.usedDigestatoSolidoRegular or 0;

        xmlFile:setFloat(key .. "#usedDigestatoSolido", usedDigestatoSolido);
        xmlFile:setFloat(key .. "#usedDigestatoSolidoRegular", usedDigestatoSolidoRegular);
    end;
end;

function CustomFertilizersPF:resetPF()
    if FillType.COMPOST ~= nil then
        self.usedCompost = 0;
        self.usedCompostRegular = 0;
    end;
    
    if FillType.DIGESTATO_SOLIDO ~= nil then
        self.usedDigestatoSolido = 0;
        self.usedDigestatoSolidoRegular = 0;
    end;
end;

function CustomFertilizersPF:onReadStreamPF(streamId, connection)
    if FillType.COMPOST ~= nil then
        self.usedCompost = streamReadFloat32(streamId);
        self.usedCompostRegular = streamReadFloat32(streamId);
    end;
    
    if FillType.DIGESTATO_SOLIDO ~= nil then
        self.usedDigestatoSolido = streamReadFloat32(streamId);
        self.usedDigestatoSolidoRegular = streamReadFloat32(streamId);
    end;
end;

function CustomFertilizersPF:onWriteStreamPF(streamId, connection)
    if FillType.COMPOST ~= nil then
        streamWriteFloat32(streamId, self.usedCompost);
        streamWriteFloat32(streamId, self.usedCompostRegular);
    end;
    
    if FillType.DIGESTATO_SOLIDO ~= nil then
        streamWriteFloat32(streamId, self.usedDigestatoSolido);
        streamWriteFloat32(streamId, self.usedDigestatoSolidoRegular);
    end;
end;


function CustomFertilizersPF:setDataPF(farmlandId, fieldNumber, fieldArea, statistic)
    local function updatePercentageText(textElement, currentValue, referenceValue, monetaryChange, invertColors)
        local percentageChange = 0;

        if currentValue == referenceValue then
            textElement:setText("");
            return percentageChange;
        end;

        local isNegative = false;
        local displayText = "";

        if referenceValue == 0 then
            if math.floor(monetaryChange or 0) > 0 then
                displayText = string.format("(+%s)", g_i18n:formatMoney(monetaryChange));
                isNegative = true;
                percentageChange = 100;
            else
                displayText = "";
            end;
        else
            local calculatedPercentage = -100 * (1 - currentValue / referenceValue);
            percentageChange = math.floor(calculatedPercentage);

            if percentageChange ~= 0 then
                local formatString = percentageChange <= 0 and "(%d%%)" or "(+%d%%)";
                displayText = string.format(formatString, percentageChange);
                isNegative = percentageChange > 0;
            end;
        end;

        if invertColors then
            isNegative = not isNegative;
        end;

        textElement:applyProfile(isNegative and "farmlandStatsDialogChangeNeg" or "farmlandStatsDialogChangePos", true);
        textElement:setText(displayText);

        return percentageChange;
    end;

    local function updateFarmlandStatistics(statistics, statIndex, key, subKey, referenceKey, fillType, showWeight, showCost, roundValues, useDecimal, unitSuffix, priceOverride, weightOverride, invertColors)
        if unitSuffix == nil then
            unitSuffix = " l";
        elseif unitSuffix:len() > 0 then
            unitSuffix = " " .. unitSuffix;
        end;

        local currentValue = statistics:getValue(key, subKey);

        if referenceKey == nil then
            referenceKey = currentValue;
        elseif type(referenceKey) == "string" then
            referenceKey = statistics:getValue(key, referenceKey);
        elseif type(referenceKey) ~= "number" then
            referenceKey = currentValue;
        end;

        local price = priceOverride or CustomFertilizersPF.modTablePF.g_precisionFarming.farmlandStatistics:getFillLevelPrice(currentValue, fillType);
        local weight = weightOverride or CustomFertilizersPF.modTablePF.g_precisionFarming.farmlandStatistics:getFillLevelWeight(currentValue, fillType);

        if showWeight then
            local formatString = "%d" .. unitSuffix;

            if useDecimal then
                formatString = "%.1f" .. unitSuffix;
            else
                currentValue = MathUtil.round(currentValue);
            end;

            formatString = formatString .. " | %.1f t";
            self.statAmountText[statIndex]:setText(formatString:format(currentValue, weight));
        else
            self.statAmountText[statIndex]:setText("");
        end;

        if showCost == nil or showCost then
            self.statCostText[statIndex]:setText(g_i18n:formatMoney(price));
        else
            self.statCostText[statIndex]:setText("");
        end;

        local percentageChange = updatePercentageText(self.statPercentageText[statIndex], currentValue, referenceKey, price, invertColors);
        local adjustedPercentage = showCost == false and 0 or percentageChange;
        local roundedPrice = math.floor(price);
        local maxPrice = math.max(roundedPrice);
        local adjustedPrice = price * (-adjustedPercentage * 0.01 + 1);
        local finalPrice = math.floor(adjustedPrice);

        return maxPrice, math.max(finalPrice, 0);
    end;

    if FillType.COMPOST ~= nil then
        updateFarmlandStatistics(statistic, 14, self.showTotal, "usedCompost", "usedCompostRegular", FillType.COMPOST, true, false, false, false);
    end;
    
    if FillType.DIGESTATO_SOLIDO ~= nil then
        updateFarmlandStatistics(statistic, 15, self.showTotal, "usedDigestatoSolido", "usedDigestatoSolidoRegular", FillType.DIGESTATO_SOLIDO, true, false, false, false);
    end;
end;