-- Script di Benvenuto per Etruria - Metodo Corretto HUD
print("ETRURIA DEBUG: WelcomeMessage.lua METODO CORRETTO caricato!")

local function createEtruriaWelcomeDialog()
    -- Verifica che sia possibile mostrare il messaggio
    if g_dedicatedServer ~= nil or g_currentMission == nil or g_currentMission.hud == nil then
        print("ETRURIA DEBUG: Ambiente non compatibile per messaggio HUD")
        return
    end

    print("ETRURIA DEBUG: Creazione dialogo di benvenuto...")

    -- Ottieni testo localizzato dai file l10n
    local title = "BENVENUTO IN ETRURIA"
    local infoText = [[

Una mappa disegnata da Edomod in collaborazione con Sbaffo Farming

TI CONSIGLIAMO VIVAMENTE DI SCARICARE QUESTA MAPPA SOLO DAL SITO UFFICIALE
www.edomod.it/etruria

Questo è l'unico sito dove potrai trovare la versione più aggiornata e sicura della mappa.
Nessun altro sito web è autorizzato dagli autori a condividere la mappa Etruria.

Buon divertimento!!!]]

    -- Prova a ottenere il testo localizzato
    if g_i18n and g_i18n.getText then
        local localizedTitle = g_i18n:getText("etruria_welcome_title")
        local localizedMessage = g_i18n:getText("etruria_welcome_message")
        
        if localizedTitle and localizedTitle ~= "" then
            title = localizedTitle
            print("ETRURIA DEBUG: Titolo localizzato caricato: " .. title)
        else
            print("ETRURIA DEBUG: Titolo localizzato non trovato, uso fallback")
        end
        
        if localizedMessage and localizedMessage ~= "" then
            infoText = "\n" .. localizedMessage
            print("ETRURIA DEBUG: Messaggio localizzato caricato")
        else
            print("ETRURIA DEBUG: Messaggio localizzato non trovato, uso fallback")
        end
    else
        print("ETRURIA DEBUG: Sistema l10n non disponibile, uso testo fallback")
    end

    local welcomeDialog = {
        startUpdateTime = 3000, -- 3 secondi di attesa
        canDisplayMessage = true,

        update = function(self, dt)
            self.startUpdateTime = self.startUpdateTime - dt

            -- Condizioni per mostrare il messaggio (come Easy Dev Controls)
            if self.startUpdateTime < 0 and 
               self.canDisplayMessage and 
               not g_gui:getIsGuiVisible() and 
               not g_currentMission.hud:isInGameMessageVisible() then
                
                print("ETRURIA DEBUG: Mostrando messaggio HUD localizzato...")
                
                -- Mostra il messaggio HUD con timer -1 (richiede click per chiudere)
                g_currentMission.hud:showInGameMessage(title, infoText, -1, nil, nil, nil)
                
                -- Rimuovi il listener dopo aver mostrato il messaggio
                removeModEventListener(self)
                self.canDisplayMessage = false
                
                print("ETRURIA DEBUG: Messaggio HUD localizzato mostrato con successo!")
            end
        end
    }

    -- Aggiungi il listener di eventi
    addModEventListener(welcomeDialog)
    print("ETRURIA DEBUG: Listener di eventi aggiunto")
end

-- Chiamata alla funzione di creazione del dialogo
local function onMissionLoaded()
    print("ETRURIA DEBUG: Mission caricata, creazione dialogo di benvenuto...")
    createEtruriaWelcomeDialog()
end

-- Hook al caricamento della missione (stesso metodo di Easy Dev Controls)
if Mission00 then
    Mission00.onStartMission = Utils.appendedFunction(Mission00.onStartMission, onMissionLoaded)
    print("ETRURIA DEBUG: Hook installato su Mission00.onStartMission")
else
    print("ETRURIA DEBUG: ERRORE - Mission00 non trovato!")
end

print("ETRURIA DEBUG: Script con metodo corretto inizializzato completamente")